// priority: 10

StartupEvents.registry("sound_event", e => {
    e.create("kubejs:ohyeah");
    e.create("kubejs:ohno");
    e.create("kubejs:maid_hurt");
    e.create("kubejs:jingbao");
    e.create("kubejs:omg");
    e.create("kubejs:shuijiao");
    e.create("kubejs:zhenjing");
    e.create("kubejs:xzg");
});

StartupEvents.registry("item", e => {
    注册所有物品(e);
});

/**
 * @param {Internal.ItemRegistar} e
 * @param {string} 物品ID
 * @param {string} 显示名称
 * @param {string} 提示文本
 * @param {string | null} 稀有度
 * @param {boolean} 是否发光
 */
function 物品(e, 物品ID, 显示名称, 提示文本, 稀有度, 是否发光) {
    let 注册物品 = e.create(物品ID)
        .displayName(显示名称)
        .tooltip(提示文本);

    if (稀有度) {
        注册物品.rarity(稀有度);
    }

    if (是否发光) {
        注册物品.glow(true);
    }
    
    注册物品.fireResistant();
}

/**
 * @param {Internal.ItemRegistar} e
 * @param {string} 物品ID
 * @param {string} 标签
 * @param {string} 显示名称
 * @param {string} 纹理
 */
function 子弹(e, 物品ID, 标签, 显示名称, 纹理) {
    e.create(物品ID)
        .tag(标签)
        .displayName(显示名称)
        .texture(纹理)
        .fireResistant();
}

/**
 * @param {Internal.ItemRegistar} e
 * @param {string} 物品ID
 * @param {string} 稀有度
 * @param {string} 显示名称
 * @param {string} 纹理
 */
function 无尽能源(e, 物品ID, 稀有度, 显示名称, 纹理) {
    e.create(物品ID)
        .attachCapability(
            CapabilityBuilder.ENERGY.customItemStack()
                .canExtract(i => true)
                .getEnergyStored(i => 100000)
                .getMaxEnergyStored(i => 100000)
                .extractEnergy((itm, i, sim) => {
                    return 100000;
                })
        )
        .maxStackSize(1)
        .rarity(稀有度)
        .displayName(显示名称)
        .texture(纹理)
        .fireResistant();
}

/**
 * @param {Internal.ItemRegistar} e
 * @param {string} id 物品ID
 * @param {string} 标签 物品标签
 * @param {string} 显示名称 显示名称
 * @param {boolean} 防火 是否防火
 * @param {string} 稀有度 物品稀有度
 * @param {number} 堆叠数量 物品的最大堆叠数量
 * @param {string} 纹理路径 纹理路径
 */
function 饰品(e, id, 标签, 显示名称, 防火, 稀有度, 堆叠数量, 纹理路径) {
    let 注册饰品 = e.create(id)
        .tag(标签)
        .displayName(显示名称)
        .rarity(稀有度)
        .texture(纹理路径)
        .maxStackSize(堆叠数量); // 设置最大堆叠数量

    if (防火) {
        注册饰品.fireResistant();
    }
}

function 注册所有物品(e) {
    // 原有物品注册
    物品(e, "gold_coin", "金币", "可在任务商店里买东西,或者村民交易", "UNCOMMON", false);
    物品(e, "diamond_coin", "钻石币", "可用于抽奖", "RARE", false);
    物品(e, "netherite_coin", "合金币", "任务里抽奖或者购买道具", "EPIC", true);
    物品(e, "monster_coin", "成就币", "做成就获取,用于商店购买特殊道具", "EPIC", true);
    物品(e, "nether_coin", "下界币", "暂无作用", null, false);
    物品(e, "end_coin", "末地币", "暂无作用", null, false);
    物品(e, "d_material", "D级材料", "用于D级枪械和配件制作以及升级材料", "TWILIGHT", false);
    物品(e, "c_material", "C级材料", "用于C级枪械和配件制作以及升级材料", "RARE", false);
    物品(e, "b_material", "B级材料", "用于B级枪械和配件制作以及升级材料", "EPIC", false);
    物品(e, "a_material", "A级材料", "用于A级枪械和配件制作以及升级材料", "LEGENDARY", true);
    物品(e, "s_material", "S级材料", "用于S级枪械和配件制作", "UNCOMMON", true);
    物品(e, "a_certificate", "A级券", "用于任务商店抽奖", "LEGENDARY", true);
    物品(e, "s_certificate", "S级券", "用于任务商店抽奖", "UNCOMMON", true);
    物品(e, "treasure_pouch1", "普通宝藏袋", "可开出常见物品材料", "TWILIGHT", false);
    物品(e, "treasure_pouch2", "稀有宝藏袋", "可开出较稀物品材料", "RARE", false);
    物品(e, "treasure_pouch3", "史诗宝藏袋", "可开出珍贵物品材料", "EPIC", false);
    物品(e, "treasure_pouch4", "传说宝藏袋", "可开出高级物品材料", "LEGENDARY", true);
    物品(e, "treasure_pouch5", "神话宝藏袋", "可开出极品物品材料", "LEGENDARY", true);

    // 子弹注册
    子弹(e, "kubejs:package_9mm", "kubejs:package_ammo", "封装的手枪弹", "ammo_for_create:item/package_9mm");
    子弹(e, "kubejs:package_12g", "kubejs:package_ammo", "封装的霰弹", "ammo_for_create:item/package_12g");
    子弹(e, "kubejs:package_3006", "kubejs:package_ammo", "封装的狙击弹", "ammo_for_create:item/package_3006");
    子弹(e, "kubejs:package_76239", "kubejs:package_ammo", "封装的步枪弹", "ammo_for_create:item/package_76239");
    子弹(e, "kubejs:package_arrow", "kubejs:package_ammo", "封装的弩箭", "ammo_for_create:item/package_arrow");
    子弹(e, "kubejs:package_emx_b1", "kubejs:package_ammo", "封装的动力电池", "ammo_for_create:item/package_emx_b1");
    子弹(e, "kubejs:package_rocket", "kubejs:package_ammo", "封装的爆破弹", "ammo_for_create:item/package_rocket");

    子弹(e, "kubejs:incomplete_12g", "kubejs:incomplete_ammo", "未完成的霰弹", "ammo_for_create:item/incomplete_12g");
    子弹(e, "kubejs:incomplete_3006", "kubejs:incomplete_ammo", "未完成的狙击弹", "ammo_for_create:item/incomplete_3006");
    子弹(e, "kubejs:incomplete_76239", "kubejs:incomplete_ammo", "未完成的步枪弹", "ammo_for_create:item/incomplete_76239");
    子弹(e, "kubejs:incomplete_arrow", "kubejs:incomplete_ammo", "未完成的弩箭", "ammo_for_create:item/incomplete_arrow");
    子弹(e, "kubejs:incomplete_emx_b1", "kubejs:incomplete_ammo", "未完成的动力电池", "ammo_for_create:item/incomplete_emx_b1");
    子弹(e, "kubejs:incomplete_rocket", "kubejs:incomplete_ammo", "未完成的爆破弹", "ammo_for_create:item/incomplete_rocket");
    
    // 无尽能源注册
    无尽能源(e, "kubejs:infinite_energy", "uncommon", "无尽能源", "infinite_thing:item/infinite_energy");

    // 饰品(e, id, 标签, 显示名称, 防火, 稀有度, 堆叠数量, 纹理路径 )
    饰品(e, "kubejs:xzg", "curios:charm", "心之钢", true, "LEGENDARY", 1, "kubejs:item/xzg");//(通常饰品不可堆叠，所以堆叠数量设为1)
    饰品(e, "kubejs:shileyuan", "curios:charm", "失乐园", true, "LEGENDARY", 1, "kubejs:item/shileyuan");
}

StartupEvents.registry("block", e => {
    e.create("kubejs:incomplete_infinite")
        .displayName('未完成的无尽方块')
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .textureAll("create:block/industrial_iron_block_top")
    e.create("kubejs:infinite_water")
        .displayName('无尽水方块')
        .model("infinite_thing:block/infinite_water")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("minecraft:water", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
    e.create("kubejs:infinite_lava")
        .displayName('无尽熔岩方块')
        .model("infinite_thing:block/infinite_lava")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("minecraft:lava", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
    e.create("kubejs:infinite_milk")
        .displayName('无尽牛奶方块')
        .model("infinite_thing:block/infinite_milk")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("minecraft:milk", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
    e.create("kubejs:infinite_honey")
        .displayName('无尽蜂蜜方块')
        .model("infinite_thing:block/infinite_honey")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("create:honey", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
    e.create("kubejs:infinite_chocolate")
        .displayName('无尽巧克力方块')
        .model("infinite_thing:block/infinite_chocolate")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("create:chocolate", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
    e.create("kubejs:infinite_tea")
        .displayName('无尽茶方块')
        .model("infinite_thing:block/infinite_tea")
        .soundType('stone')
        .hardness(2.0)
        .resistance(1000.0)
        .tagBlock('minecraft:mineable/pickaxe')
        .blockEntity(info => {
            info.attachCapability(CapabilityBuilder.FLUID.customBlockEntity()
                .getFluid(() => {
                    return Fluid.of("create:tea", 64000)
                })
                .onDrain(() => {
                    return 64000
                })
                .getCapacity(() => {
                    return 64000
                })
            )
        })
})

let 自定义工具列表 = [
    {
        // 物品的唯一ID
        id: "kubejs:ice_tofu",
        // 工具的基础类型
        type: "pickaxe",
        // 游戏内显示的名称
        name: "§b冰豆腐砖", 
        // 物品的纹理路径
        texture: "kubejs:item/tofu", 
        // 要使用的性能等级ID
        tier: "kubejs:experimental",
        // 攻击伤害加成
        damageBonus: 98,
        // 攻击速度修正值
        speedBaseline: -1.0,
        // 是否自带附魔光效
        glow: true,
        // 提示文本
        tooltip: "§6终于可以一头撞死了。"
    },
];

/**
 * @param {Internal.ItemRegistar} e - KubeJS的注册事件对象。
 * @param {object} toolData - 包含工具所有信息的对象。
 */
function 注册单个自定义工具(e, toolData) {
    // 使用 let 声明一个变量来存储正在构建的物品
    let builder = e.create(toolData.id, toolData.type)
        .displayName(toolData.name) // 设置物品显示名称
        .texture(toolData.texture) // 设置物品纹理路径
        .rarity("epic") // 设置物品稀有度为史诗
        .maxStackSize(1) // 设置最大堆叠数量为1
        .unstackable() // 设置物品不可堆叠
        .fireResistant() // 设置物品防火
        .tier(toolData.tier) // 设置工具等级
        .attackDamageBonus(toolData.damageBonus) // 设置攻击伤害加成
        .speedBaseline(toolData.speedBaseline); // 设置攻击速度修正

    // 添加可选属性
    if (toolData.glow) {
        builder.glow(true);
    }
    if (toolData.tooltip) {
        builder.tooltip(Text.gray(toolData.tooltip));
    }
}

// 定义工具等级的事件
ItemEvents.toolTierRegistry(e => {
    e.add("kubejs:experimental", tier => {
        tier.level = 8; // 挖掘等级
        tier.speed = 50.0; // 挖掘速度
        tier.uses = 0; // 耐久度
        tier.enchantmentValue = 30; // 附魔能力
        tier.repairIngredient = "#forge:tofu"; // 修复材料
    });
});

// 注册物品的事件
StartupEvents.registry("item", e => {
    // 遍历工具列表
    for (let tool of 自定义工具列表) {
        // 调用我们修改了名字的新函数
        注册单个自定义工具(e, tool); 
    }
});